/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jei;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class PlantIngredient {
    public static final IIngredientType<AgriPlant> TYPE = () -> AgriPlant.class;
    public static final IIngredientHelper<AgriPlant> HELPER = new IIngredientHelper<AgriPlant>(){

        public IIngredientType<AgriPlant> getIngredientType() {
            return TYPE;
        }

        public String getDisplayName(AgriPlant plant) {
            return LangUtils.plantName(AgriApi.getPlantId(plant).map(class_2960::toString).orElse("agricraft:unknown")).getString();
        }

        public String getUniqueId(AgriPlant plant, UidContext context) {
            return AgriApi.getPlantId(plant).map(class_2960::toString).orElse("agricraft:unknown");
        }

        public class_2960 getResourceLocation(AgriPlant plant) {
            return AgriApi.getPlantId(plant).orElse(new class_2960("agricraft:unknown"));
        }

        public AgriPlant copyIngredient(AgriPlant plant) {
            return plant;
        }

        public String getErrorInfo(AgriPlant plant) {
            return AgriApi.getPlantId(plant).map(class_2960::toString).orElse("agricraft:unknown");
        }
    };
    public static final IIngredientRenderer<AgriPlant> RENDERER = new IIngredientRenderer<AgriPlant>(){

        public void render(class_332 guiGraphics, AgriPlant plant) {
            Optional<class_2960> optional = AgriApi.getPlantId(plant);
            if (optional.isPresent()) {
                class_2960 plantId = optional.get();
                class_1087 model = AgriClientApi.getPlantModel(plantId.toString(), plant.getInitialGrowthStage().total() - 1);
                class_1058 sprite = model.method_4711();
                guiGraphics.method_25298(0, 0, 0, 16, 16, sprite);
            }
        }

        public List<class_2561> getTooltip(AgriPlant ingredient, class_1836 tooltipFlag) {
            ArrayList<class_2561> list = new ArrayList<class_2561>();
            AgriApi.getPlantId(ingredient).map(class_2960::toString).ifPresent(id -> {
                list.add(LangUtils.plantName(id));
                class_2561 desc = LangUtils.plantDescription(id);
                if (desc != null) {
                    list.add(desc);
                }
            });
            return list;
        }
    };
}

